import React from "react";
import { useWindowDimensions } from "react-native";
import RenderHtml from "react-native-render-html";

const tagsStyles = {
    span: {
        overflow: "hidden",
    },
    img: {
        overflow: "hidden",
        marginHorizontal: "auto",
    },
};

const ParseHTML = ({ description }) => {
    const { width } = useWindowDimensions();
    const additional = `<p><br></p><p><br></p>`;
    const cleanDescription = description.replace(
        /<span([^>]*)style="([^"]*?)\bheight:\s*[^;]+;([^"]*?)"([^>]*)>([^<]*<img\b[^>]*>.*?)<\/span>/gi,
        (match, before, styleBefore, styleAfter, after, content) => {
            const cleanedStyle = `${styleBefore}${styleAfter}`.replace(/\s*;\s*$/, "").trim();
            const styleAttr = cleanedStyle ? ` style="${cleanedStyle}"` : "";
            return `<span${before}${styleAttr}${after}>${content}</span>`;
        }
    );
    
    const formattedDes = cleanDescription.replace(
        /<font(.*?)color="(.*?)"(.*?)>(.*?)<\/font>/gi,
        '<span$1style="color: $2;"$3>$4</span>'
    );
    const fullDescription = formattedDes + additional;
    const source = {
        html: fullDescription
    };
    return (
        description && (
            <RenderHtml
                contentWidth={width}
                source={source}
                tagsStyles={tagsStyles}
            />
        )
    );
};

export default ParseHTML;
